package com.bxm.localnews.news.util;

import com.bxm.localnews.news.dto.LocationDTO;
import com.bxm.localnews.news.model.vo.ForumPostVo;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

import static com.bxm.localnews.news.constant.GlobalConstant.LOCAL_NAME;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

/**
 * @author liujia
 * @date 1/14/21 3:46 PM
 **/
public class FormPostContentUtil {
    private FormPostContentUtil() {

    }

    /**
     * 替换地区占位符
     *
     * @param content  要替换之前的内容
     * @param location 地区信息
     * @return 替换后的结果
     */
    public static String replace(String content, LocationDTO location) {
        //开启占位符
        if (Objects.nonNull(content)) {
            if (location == null) {
                location = new LocationDTO();
            }

            return PlaceHolderUtil.replace(content, "areaname", location.getName(), LOCAL_NAME);
        }
        return null;
    }

    public static void replace(ForumPostVo postVo, LocationDTO location) {
        //开启占位符
        if (Objects.nonNull(postVo)) {
            if (location == null) {
                location = new LocationDTO();
            }

            postVo.setTitle(replace(postVo.getTitle(), location));
            postVo.setContent(replace(postVo.getContent(), location));
            postVo.setTextField(replace(postVo.getTextField(), location));
        }
    }

    public static String getForumPostTitle(String title, String textField) {
        String forumTitle = title;
        if (isNotBlank(forumTitle)) {
            forumTitle = forumTitle.length() > 10 ? forumTitle.substring(0, 10) + "..." : forumTitle;
        } else {
            forumTitle = textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }

    public static String getForumPostTitleTotally(String title, String textField) {
        String forumTitle = title;
        if (StringUtils.isBlank(forumTitle)) {
            forumTitle = textField.length() > 10 ? textField.substring(0, 10) + "..." : textField;
        }
        return forumTitle;
    }
}
