package com.bxm.egg.common.url;

import com.bxm.foundation.base.facade.service.DomainFacadeService;
import com.google.common.base.Charsets;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

/**
 * @author liujia
 * @date 1/20/21 3:18 PM
 **/
class AbstractProtocolBuilder {

    protected DomainFacadeService domainIntegrationService;

    AbstractProtocolBuilder(DomainFacadeService domainIntegrationService) {
        this.domainIntegrationService = domainIntegrationService;
    }

    String encode(String source) {
        try {
            return URLEncoder.encode(source, Charsets.UTF_8.name());
        } catch (UnsupportedEncodingException e) {
            // do nothing
        }
        return source;
    }
}
