package com.bxm.egg.common.sharding;

import com.bxm.egg.common.vo.IKindIdSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 频道ID进行的分表策略
 */
public class KindIdStrategy implements ShardStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(KindIdStrategy.class);

    @Override
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof IKindIdSharding) {
            IKindIdSharding sharding = (IKindIdSharding) params;
            if (sharding.getKindId() == null || sharding.getKindId() == 0) {
                LOGGER.error("根据kindId进行分表，必须有值，实际值是0");
            } else {
                return getTableName(sharding.getKindId(), baseTableName);
            }
        } else if (params instanceof Long) {
            return getTableName((Long) params, baseTableName);
        } else if (params instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) params;
            Object newsId = paramMap.get("kindId");
            if (newsId instanceof Long) {
                return getTableName((Long) newsId, baseTableName);
            } else {
                LOGGER.error("根据kindId进行分表，Map类型参数中必须有键名为[kindId]的值，而且类型为Long");
            }
        } else {
            LOGGER.error("[{}][{}]已分表，参数支持[{}]或[Long]，请修改", mapperId, baseTableName, IKindIdSharding.class);
        }
        return baseTableName;
    }

    private String getTableName(Long kindId, String baseTableName) {

        List<Long> kindList = new ArrayList<>();
        kindList.add(32L);
        kindList.add(20L);
        kindList.add(18L);
        kindList.add(14L);
        kindList.add(69L);
        kindList.add(27L);
        kindList.add(22L);
        if (kindList.contains(kindId)) {
            return baseTableName + "_" + kindId;
        }
        return baseTableName + "_other" ;
    }

}