package com.bxm.egg.common.url;

import com.bxm.egg.common.constant.AppConst;
import com.bxm.foundation.base.facade.enums.DomainScene;
import com.bxm.foundation.base.facade.enums.DomainViewScene;
import com.bxm.foundation.base.facade.param.DomainFetchParam;
import com.bxm.foundation.base.facade.service.DomainFacadeService;

/**
 * 用户个人中心页面
 *
 * @author liujia
 * @date 1/20/21 5:06 PM
 **/
public class HomeProtocolBuilder extends AbstractProtocolBuilder {

    HomeProtocolBuilder(DomainFacadeService domainIntegrationService) {
        super(domainIntegrationService);
    }

    /**
     * 构建站外分享地址
     */
    public OuterProtocolBuilder outer() {
        return new OuterProtocolBuilder();
    }

    /**
     * 构建站内访问协议地址
     */
    public AppProtocolBuilder app() {
        return new AppProtocolBuilder();
    }

    public class OuterProtocolBuilder {

        private Long targetUserId;

        private Long userId;

        private String areaCode;

        private String areaName;

        public OuterProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public OuterProtocolBuilder targetUserId(Long targetUserId) {
            this.targetUserId = targetUserId;
            return this;
        }

        public OuterProtocolBuilder areaCode(String areaCode) {
            this.areaCode = areaCode;
            return this;
        }

        public OuterProtocolBuilder areaName(String areaName) {
            this.areaName = areaName;
            return this;
        }

        public String build() {
            String baseUrl = domainIntegrationService.getBaseUrlInfo(DomainFetchParam.builder()
                    .srcApp(AppConst.SRC_APP)
                    .scene(DomainScene.OUTSIDE_SHARE)
                    .viewScene(DomainViewScene.CONTENT_VIEW)
                    .build());

            StringBuilder url = new StringBuilder();
            url.append(baseUrl);
            url.append("/shareUserHome.html?userId=").append(userId);

            if (null != targetUserId) {
                url.append("&targetUserId=").append(targetUserId);
            }
            if (null != areaCode) {
                url.append("&areaCode=").append(areaCode);
            }
            if (null != areaName) {
                url.append("&areaName=").append(encode(areaName));
            }

            return url.toString();
        }
    }

    public class AppProtocolBuilder {
        private Long userId;

        private Integer toast = 0;

        public AppProtocolBuilder userId(Long userId) {
            this.userId = userId;
            return this;
        }

        public AppProtocolBuilder toast(Integer toast) {
            this.toast = toast;
            return this;
        }

        public String build() {
            return "wst://mine/userHomePage?userId=" + userId + "&toast=" + toast;
        }
    }
}
