package com.bxm.egg.common.sharding;

import com.bxm.egg.common.vo.IUserIdSharding;
import com.google.code.shardbatis.strategy.ShardStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

/**
 * 用户ID进行的分表策略
 */
public class UserIdStrategy implements ShardStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserIdStrategy.class);

    @Override
    public String getTargetTableName(String baseTableName, Object params, String mapperId) {
        if (params instanceof IUserIdSharding) {
            IUserIdSharding sharding = (IUserIdSharding) params;
            if (sharding.getUserId() == null) {
                LOGGER.error("根据userId进行分表，必须有值");
            } else {
                return getTableName(sharding.getUserId(), baseTableName);
            }
        } else if (params instanceof Long) {
            return getTableName((Long) params, baseTableName);
        } else if (params instanceof Map) {
            Map<String, Object> paramMap = (Map<String, Object>) params;
            Object userId = paramMap.get("userId");
            if (userId instanceof Long) {
                return getTableName((Long) userId, baseTableName);
            } else {
                LOGGER.error("根据userId进行分表，Map类型参数中必须有键名为[userId]的值，而且类型为Long");
            }
        } else {
            LOGGER.error("[{}][{}]已分表，参数支持[{}]或[Long]，请修改", mapperId, baseTableName, IUserIdSharding.class);
        }
        return baseTableName;
    }

    private String getTableName(Long userId, String baseTableName) {
        return baseTableName + "_" + (userId % 10);
    }

}