package com.bxm.egg.common.utils;

import com.bxm.egg.common.constant.RespCode;
import com.bxm.egg.common.vo.Json;

/**
 * 响应结果转换工具类
 * 用于和原本黄瓜头条中的API进行适配
 *
 * @author liujia
 */
public class ResultUtil {

    public static <T> Json<T> genSuccessResult() {
        return Json.build(RespCode.OK, "");
    }

    public static <T> Json<T> genSuccessMsg() {
        return Json.build(RespCode.OK, "操作成功");
    }

    public static <T> Json<T> genSuccessMsg(String msg) {
        return Json.build(RespCode.OK, msg);
    }

    public static <T> Json<T> genSuccessResult(T data) {
        return Json.build(RespCode.OK, "", data);
    }

    public static <T> Json<T> genFailedResult(String msg) {
        return Json.build(RespCode.BAD_REQUEST, msg);
    }

    public static <T> Json<T> genFailedResult(int code, String msg) {
        return Json.build(code, msg);
    }

    public static <T> Json<T> genFailedResult(int code, String msg, T data) {
        return Json.build(code, msg, data);
    }

}
