/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.mq.common.model.dto;

import com.bxm.egg.mq.common.constant.MessageBehaviorEnum;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.newidea.component.JSONObject;
import com.bxm.newidea.component.vo.BaseBean;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

@ApiModel(description="\u6d88\u606f\u4e3b\u4f53\u5185\u5bb9")
public class PushPayloadInfo
extends BaseBean {
    @ApiModelProperty(value="\u5f53\u524d\u63a8\u9001\u6d88\u606f\u7684ID")
    private Long msgId;
    @ApiModelProperty(value="\u63a8\u9001\u7684\u6d88\u606f\u7c7b\u578b,\u8be6\u89c1\u6587\u6863\u5e93\u4e2d\u7684\u76f8\u5173\u5b9a\u4e49")
    private int type = 0;
    @ApiModelProperty(value="\u521b\u5efa\u6d88\u606f\u7684\u65f6\u95f4(\u65f6\u95f4\u6233)")
    private Long createTime;
    @ApiModelProperty(value="\u6d88\u606f\u6807\u9898")
    private String title;
    @ApiModelProperty(value="\u6d88\u606f\u5185\u5bb9")
    private String content;
    @ApiModelProperty(value="\u901a\u77e5\u4f7f\u7528\u7684\u94c3\u58f0")
    private String sound;
    @ApiModelProperty(value="\u8df3\u8f6c\u534f\u8bae \u4ee5\u524d\u662f\u628aurl\u653e\u5728 extend\u4e2d\uff0c\u5f80\u540e\u53ef\u4ee5\u76f4\u63a5\u653e\u5230\u8fd9\u4e2a\u5b57\u6bb5\uff0c\u5ba2\u6237\u7aef\u62ff\u5230\u76f4\u63a5\u8df3\u8f6c")
    private String protocol;
    @ApiModelProperty(value="\u662f\u5426\u9700\u8981\u5728\u6d88\u606f\u4e2d\u5fc3\u663e\u793a\u67e5\u770b\u8be6\u60c5\uff0c\u5982\u679c\u4e3anull\u5219\u4e0d\u505a\u5904\u7406\uff0c\u6309\u7167\u5386\u53f2\u903b\u8f91\u5904\u7406\uff0c\u5982\u679c\u4e3atrue\u5219\u663e\u793a\u67e5\u770b\u8be6\u60c5\uff0c\u5982\u679c\u4e3afalse\u5219\u4e0d\u663e\u793a")
    private Boolean hasDetail;
    @ApiModelProperty(value="\u989d\u5916\u53c2\u6570\uff0c\u6839\u636e\u5f53\u524d\u7684\u63a8\u9001\u7c7b\u578b\u4f1a\u6709\u4e0d\u540c\u7684\u8fd4\u56de\u503c")
    private Map<String, Object> extend = Maps.newHashMap();

    public static PushPayloadInfo build() {
        return new PushPayloadInfo().setCreateTime(System.currentTimeMillis());
    }

    public static PushPayloadInfo build(PushMessageEnum type) {
        PushPayloadInfo info = new PushPayloadInfo();
        info.setType(type.getType());
        info.setCreateTime(System.currentTimeMillis());
        return info;
    }

    public Long getTargetUserId() {
        Object userIdObj = this.getExtend().get("userId");
        if (null == userIdObj) {
            return null;
        }
        if (userIdObj instanceof Long) {
            return Long.valueOf(userIdObj.toString());
        }
        return NumberUtils.toLong((String)userIdObj.toString());
    }

    public void addTargetUserId(Long userId) {
        this.addExtend("userId", userId);
    }

    public PushPayloadInfo addExtend(String key, Object value) {
        if (this.extend == null) {
            this.extend = Maps.newHashMap();
        }
        this.extend.put(key, value);
        return this;
    }

    public Long getMsgId() {
        return this.msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String toJsonString() {
        return JSONObject.toJSONString((Object)((Object)this));
    }

    public Map<String, Object> getExtend() {
        return this.extend;
    }

    public void setExtend(Map<String, Object> extend) {
        this.extend = extend;
    }

    public int getType() {
        return this.type;
    }

    public PushPayloadInfo setType(int type) {
        this.type = type;
        PushMessageEnum messageType = PushMessageEnum.getMessageByType(type);
        if (messageType != null) {
            this.hasDetail = MessageBehaviorEnum.JUMP.equals((Object)messageType.getBehavior());
        }
        return this;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public PushPayloadInfo setCreateTime(Long createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public PushPayloadInfo setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getContent() {
        return this.content;
    }

    public PushPayloadInfo setContent(String content) {
        this.content = content;
        return this;
    }

    public String getSound() {
        return this.sound;
    }

    public PushPayloadInfo setSound(String sound) {
        this.sound = sound;
        return this;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public PushPayloadInfo setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public Boolean getHasDetail() {
        return this.hasDetail;
    }

    public PushPayloadInfo setHasDetail(Boolean hasDetail) {
        this.hasDetail = hasDetail;
        return this;
    }
}

