package com.bxm.egg.user.dto;

import com.bxm.newidea.component.tools.DateUtils;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/2/25 8:36 下午
 */
@Data
@ApiModel("用户获得勋章弹窗信息")
public class UserGrantMedalDTO implements Serializable {

    private static final long serialVersionUID = 4017847840411734433L;
    @ApiModelProperty("勋章id")
    private Long medalId;

    @ApiModelProperty("勋章名称")
    private String medalName;

    @JsonFormat(pattern = DateUtils.DATE_FORMAT)
    @ApiModelProperty("授予勋章的日期，已经格式化")
    private Date grantDate;

    @ApiModelProperty("勋章图片url")
    private String medalImgUrl;

    @ApiModelProperty("跳转地址")
    private String jumpUrl;
}