package com.bxm.egg.user.enums;

/**
 * 用户等级配置
 * Created by Administrator on 2018/3/8.
 */
public enum LevelEnum {

    INITIAL_USER((byte) 0, "白丁"),
    LOSER((byte) 1, "屌丝"),
    BLUE_COLLAR((byte) 2, "蓝领"),
    GRAY_COLLAR((byte) 3, "灰领"),
    WHITE_COLLAR((byte) 4, "白领"),
    CALIFORNIA((byte) 5, "金领"),
    PARTNER((byte) 6, "合伙人"),
    CHAIRMAN((byte) 7, "董事长");

    private Byte type;

    private String desc;

    LevelEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getLevelEunm(Byte type) {
        for (LevelEnum levelEnum : LevelEnum.values()) {
            if (levelEnum.getType().equals(type)) {
                return levelEnum.getDesc();
            }
        }
        return null;
    }

    public Byte getType() {
        return this.type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
