package com.bxm.egg.user.param;

import com.bxm.egg.user.enums.WarmRuleEnum;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.io.Serializable;

/**
 * @author lowi
 * @date 2021/3/3 11:25
 */
@Data
@Builder
public class UserWarmActionParam implements Serializable {

    private static final long serialVersionUID = 7323053164488480179L;

    @Tolerate
    private UserWarmActionParam() {
    }

    /**
     * 处理动作
     */
    private WarmRuleEnum warmRuleEnum;

    /**
     * 温暖值
     */
    private Integer warmValue;

    /**
     * 账号所属用户ID
     */
    private Long userId;

    /**
     * 扩展数据  比如连续签到了几天
     */
    private Object extData;


    /**
     * 描述
     */
    private String remake;

}
