package com.bxm.egg.user.utils;

import java.time.LocalDate;
import java.util.Objects;

public class ConstellationUtils {

    public enum Constellation {
        Capricorn(1, "摩羯座"),
        Aquarius(2, "水瓶座"),
        Pisces(3, "双鱼座"),
        Aries(4, "白羊座"),
        Taurus(5, "金牛座"),
        Gemini(6, "双子座"),
        Cancer(7, "巨蟹座"),
        Leo(8, "狮子座"),
        Virgo(9, "处女座"),
        Libra(10, "天秤座"),
        Scorpio(11, "天蝎座"),
        Sagittarius(12, "射手座");

        Constellation(int code, String chineseName) {
            this.code = code;
            this.chineseName = chineseName;
        }

        private int code;
        private String chineseName;

        public int getCode() {
            return this.code;
        }

        public String getChineseName() {
            return this.chineseName;
        }
    }

    private static final Constellation[] CONSTELLATIONS = {
            Constellation.Aquarius, Constellation.Pisces, Constellation.Aries,
            Constellation.Taurus, Constellation.Gemini, Constellation.Cancer,
            Constellation.Leo, Constellation.Virgo, Constellation.Libra,
            Constellation.Scorpio, Constellation.Sagittarius,
            Constellation.Capricorn
    };


    /**
     * 星座的开始时间 和 CONSTELLATIONS 数组中 1 1 对应
     */
    private static final int[] CONSTELLATION_EDGE_DAY = {20, 19, 21, 20, 21, 22,
            23, 23, 23, 24, 23, 22};

    public static String calculateConstellation(LocalDate birthday) {
        if (Objects.nonNull(birthday)) {
            int day = birthday.getDayOfMonth();
            int month = birthday.getMonthValue();
            month = day < CONSTELLATION_EDGE_DAY[month - 1] ? month - 1 : month;
            return month > 0 ? CONSTELLATIONS[month - 1].getChineseName() : CONSTELLATIONS[11].getChineseName();
        }
        return null;
    }

}
