package com.bxm.egg.user.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 鉴权相关缓存键值定义
 *
 * @author liujia
 */
public class AuthRedisKey {
    private AuthRedisKey() {
    }

    /**
     * 用户拥有的鉴权编码集合
     * Hash结构
     * subKey为用户ID
     * value为对应用户拥有的权限编码
     */
    public static KeyGenerator USER_AUTH_CODE = DefaultKeyGenerator.build("user", "auth", "code");

    /**
     * 用户鉴权资源（访问某资源必须拥有的数据资源信息）
     * Hash结构
     * key为用户ID
     * subkey：用户的权限位
     * value：该权限位需要的数据资源ID
     */
    public static KeyGenerator USER_AUTH_RESOURCE = DefaultKeyGenerator.build("user", "auth", "resource");
}
