package com.bxm.egg.user.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * 分布式锁 key 常量类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/5/31 2:42 下午
 */
public class BaseDistributeKeyConstant {

    /**
     * 基础Redis Key
     */
    private static KeyGenerator BASE_KEY = DefaultKeyGenerator.build().setModule("user").setGroup("lock");


    /**
     * 注销用户
     */
    public static KeyGenerator CANCEL_USER_LOCK_KEY = BASE_KEY.copy().appendKey("cancel_user");

    /**
     * 用户绑定微信
     */
    public static KeyGenerator USER_BIND_WX_LOCK_KEY = BASE_KEY.copy().appendKey("bind_wx");


    /**
     * 设置用户为测试用户
     */
    public static KeyGenerator SET_TEST_USER_LOCK_KEY = BASE_KEY.copy().appendKey("test_user");


}