package com.bxm.egg.user.enums;

import com.bxm.newidea.component.tools.StringUtils;

/**
 * @author zhaoyadong 2019/3/7 19:23
 * @desc
 */
public enum CashFlowTypeEnum {

    /**
     * 小程序推广赏金
     */
    APPLET_BOUNTY("APPLET_PROMOTE_BOUNTY", "推广赏金"),

    /**
     * 推广赏金：受邀人进入APP，邀请人获得的推广赏金
     **/
    PROMOTE_BOUNTY("PROMOTE_BOUNTY", "推广赏金"),
    /**
     * 推广赏金：受邀人获得的推广赏金
     **/
    SELF_BOUNTY("SELF_BOUNTY", "新用户红包"),
    /**
     * 用户赏金提现到微信
     */
    WECHAT_WITHDRAWAL("WECHAT_WITHDRAWAL", "提现到微信"),

    /**
     * 支付宝提现
     */
    ALIPAY_WITHDRAWAL("ALIPAY_WITHDRAWAL", "提现到支付宝"),
    /**
     * 首次登陆APP领取新人红包
     */
    RED_PACKET("RED_PACKET", "新用户红包"),
    /**
     * 口令红包
     */
    COMMAND_RED_PACKET("COMMAND_RED_PACKET", "口令红包"),
    /**
     * 用户提现失败，资金退回
     */
    FAIL_WITHDRAWAL("FAIL_WITHDRAWAL", "提现失败，资金退回"),

    /**
     * 发起提现
     */
    WITHDRAWAL("WITHDRAWAL", "发起提现"),

    /**
     * 提现审核通过或者直接通过
     */
    WITHDRAWAL_SUCCESS("WITHDRAWAL_SUCCESS", "提现成功"),

    /**
     * 邀请人与受邀人24小时内没成功绑定关系，邀请人赏金失效
     */
    INVALID_BOUNTY("INVALID_BOUNTY", "推广赏金失效"),

    /**
     * 受邀人赏金失效
     */
    INVALID_PACKET("INVALID_PACKET", "新用户红包失效"),

    /**
     * 领红包
     */
    IM_CHAT_ROOM_RED_PACKET("IM_CHAT_ROOM_RED_PACKET", "聊天室红包"),

    /**
     * 用户邀请的人付费开通了VIP，获得返佣
     */
    INVITE_VIP("INVITE_VIP", "邀请开卡成功"),

    /**
     * 购物返佣金额
     */
    REBATE_CASH("REBATE_CASH", "购物返佣"),

    /**
     * 外卖返佣金额
     */
    TAKE_OUT_REBATE_CASH("TAKE_OUT_REBATE_CASH", "外卖返佣"),

    /**
     * 备选类型，不参与业务使用
     */
    OTHER("OTHER", "其他"),

    INVITE_REG_AWARD_CASH("INVITE_REG_AWARD_CASH", "邀请好友注册奖励"),

    INVITE_POST_AWARD_CASH("INVITE_POST_AWARD_CASH", "邀请好友发帖奖励"),
    ;

    public static CashFlowTypeEnum get(String code) {
        for (CashFlowTypeEnum value : values()) {
            if (StringUtils.equalsAny(code, value.getName(), value.name)) {
                return value;
            }
        }

        return OTHER;
    }

    /**
     * 流水类型
     **/
    private String name;

    /**
     * 流水描述
     **/
    private String desc;

    CashFlowTypeEnum(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
