package com.bxm.egg.user.enums;

/**
 * 客户端设备标识枚举类
 * Created by Administrator on 2018/3/8.
 */
public enum EquipmentEnum {

    IMEI("IMEI", "android：表示唯一值，不同手机返回不同（ D EVICE_ID/MAC 等 ），本文档中主要用于表示设备唯一码。重置系统不会重置，需要申请权限后获取"),
    ANDROID_ID("ANDROID_ID", "android：安卓系统初始化时创建一次，重置系统会被重置"),
    UUID("UUID", "android：每次即生成的uuid"),
    IDFA("IDFA", "ios：中的 广告追踪 I D ， 用户可进行重置或阻止追踪 （返回 16 个 0 ）"),
    DEVICE_ID("DEVICE_ID", "ios：本文档中特指 iOS 设备号，由 App 创建后上传，可保证同一设备同一 App 重复安装仍保持一致");

    private String type;

    private String desc;

    EquipmentEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getLevelEunm(String type) {
        for (EquipmentEnum levelEnum : EquipmentEnum.values()) {
            if (levelEnum.getType().equals(type)) {
                return levelEnum.getDesc();
            }
        }
        return null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

}
