package com.bxm.egg.user.constant;

import com.bxm.newidea.component.sync.constants.BroadcastStrategyEnum;
import com.bxm.newidea.component.sync.key.SyncCacheKey;

import java.util.concurrent.TimeUnit;

/**
 * 二级缓存key配置类
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/17 3:09 下午
 */
public class MemoryCacheKeyConfig {

    /**
     * 用户信息缓存
     */
    public static SyncCacheKey MEMORY_CACHE_KEY = SyncCacheKey.builder("user", "info")
            .maximumSize(100000)
            .duration(24)
            .timeUnit(TimeUnit.HOURS)
            .expiredAfterRead()
            .build();

    /**
     * 各地区推荐的用户
     */
    public static SyncCacheKey RECOMMEND_USER_CACHE_KEY = SyncCacheKey.builder("user", "recommend")
            .maximumSize(10000)
            .duration(1)
            .timeUnit(TimeUnit.HOURS)
            .build();
}