package com.bxm.egg.user.constant;

import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;

/**
 * redis 缓存的key值，格式为： {业务类型：模块：子模块:更下级模块} 业务类型： biz:业务 config:配置
 */
public class RedisConfig {

    /**
     * 用户标签缓存键值
     */
    public static KeyGenerator USER_TAG = DefaultKeyGenerator.build("user", "cache", "user_tag");

    /**
     * 用户缓存相关键值
     */
    public static KeyGenerator USER_VISIT_NUM = DefaultKeyGenerator.build("user", "cache");

    /**
     * 用户最近被访问总数
     */
    public static KeyGenerator USER_LATELY_VISIT_NUM = DefaultKeyGenerator.build("user", "cache", "lately_visit_num");

    /**
     * 同城人推荐缓存
     */
    public static KeyGenerator USER_RECOMMEND = DefaultKeyGenerator.build("user", "recommend");

    /**
     * 用户提现、二次登录状态：1 已提现 2 第二天登录
     */
    public static KeyGenerator USER_WITHDRAW_LOGIN_TWICE = DefaultKeyGenerator.build("user", "withdraw_login_twice");

    /**
     * 用户关注列表
     */
    public static KeyGenerator USER_FOLLOW_LIST = DefaultKeyGenerator.build("user", "follow_list");

    /**
     * 用户关注的通知消息,用于在客户端私聊时进行显示
     */
    public static KeyGenerator COMSUME_FOLLOW_INFO = DefaultKeyGenerator.build("user", "comsume", "follow");

    /**
     * 记录 用户据上次登录时间有多少人访问主页,并发送系统消息的时间
     */
    public static KeyGenerator USER_ACCESS_MESSAGE = DefaultKeyGenerator.build("user", "homepage", "systemmessage");

    /**
     * 拉黑缓存
     */
    public static KeyGenerator USER_BLOCK_LIMIT = DefaultKeyGenerator.build("user", "limit", "block");

    /**
     * 推荐降权缓存
     */
    public static KeyGenerator RECOMMEND_BLOCK_LIMIT = DefaultKeyGenerator.build("user", "limit", "recommend");

    /**
     * 用户弹窗缓存
     */
    public static KeyGenerator USER_CACHE_POPUP = DefaultKeyGenerator.build("thirdparty", "pop", "cache");

    public static KeyGenerator ACCOUNT_MATERIAL_TIPS = DefaultKeyGenerator.build("user", "material", "tips");

    public static KeyGenerator ACCOUNT_MATERIAL_PERFECT = DefaultKeyGenerator.build("user", "material", "perfect");

    /**
     * 用户温暖值信息
     */
    public static KeyGenerator USER_WARM_INFO = DefaultKeyGenerator.build("user", "warm", "info");

    /**
     * 用户温暖值信息
     */
    public static KeyGenerator USER_WARM_FIRST_INTO = DefaultKeyGenerator.build("user", "firstInto", "warmPage");

    /**
     * 温暖值等级列表信息
     */
    public static KeyGenerator USER_WARM_LEVEL_LIST = DefaultKeyGenerator.build("user", "warmLevel");

    /**
     * 温暖值权益列表信息
     */
    public static KeyGenerator USER_WARM_EQUITY_LIST = DefaultKeyGenerator.build("user", "warmEquity");

    /**
     * 用户是否完善过数据发放温暖值
     */
    public static KeyGenerator USER_DATA_FINISH_WARM = DefaultKeyGenerator.build("user", "warm", "dataFinish");

    /**
     * 用户注册发放温暖值
     */
    public static KeyGenerator USER_REGISTER_WARM = DefaultKeyGenerator.build("user", "warm", "register");

    /**
     * 温暖值规则信息数据
     */
    public static KeyGenerator WARM_RULE_DATA = DefaultKeyGenerator.build("user", "warm", "rule");

    /**
     * 用户每日登录发放温暖值
     */
    public static KeyGenerator USER_LOGIN_WARM = DefaultKeyGenerator.build("user", "warm", "login");

    /**
     * 用户每日签到发放温暖值
     */
    public static KeyGenerator USER_SIGN_WARM = DefaultKeyGenerator.build("user", "warm", "sign");

    /**
     * 用户每日发布帖子并审核通过发放温暖值
     */
    public static KeyGenerator USER_AUDIT_POST_WARM = DefaultKeyGenerator.build("user", "warm", "auditPost");
    /**
     * 用户每日发布帖子并审核通过发放温暖值
     */
    public static KeyGenerator USER_COMMENT_WARM = DefaultKeyGenerator.build("user", "warm", "comment");
    /**
     * 用户商家认证通过发放温暖值
     */
    public static KeyGenerator USER_MERCHANT_AUTN_WARM = DefaultKeyGenerator.build("user", "warm", "merchantAuth");

    /**
     * 用户商家认证通过发放温暖值
     */
    public static KeyGenerator USER_WARM_LEVEL_PUSH = DefaultKeyGenerator.build("user", "warm", "levelPush");

    /**
     * 用户封面信息
     */
    public static KeyGenerator USER_COVER_INFO = DefaultKeyGenerator.build("user", "cover", "info");
    /**
     * 成就勋章缓存数据
     */
    public static KeyGenerator ACHIEVEMNET_MEDAL_DATA = DefaultKeyGenerator.build("user", "medal", "achievement");

    /**
     * 用户获得勋章弹窗，缓存有值表示这个弹窗信息需要弹出
     */
    public static KeyGenerator USER_POP_MEDAL_DATA = DefaultKeyGenerator.build("user", "medal", "pop");

    /**
     * 用户升级弹窗
     */
    public static KeyGenerator USER_LEVLE_UP_POP = DefaultKeyGenerator.build("user", "levelUp", "pop");

    /*****************蛋蛋佳v1.2.0**********************/
    /**
     * 用户的刷新token
     */
    public static KeyGenerator USER_REFRESH_TOKEN_CACHE_KEY = DefaultKeyGenerator.build("user", "cache", "token");


    /**
     * 用户缓存信息key
     */
    public static KeyGenerator USER_INFO_CACHE_KEY = DefaultKeyGenerator.build("user", "cache", "info");

    /**
     * 用户禁止评论缓存
     */
    public static KeyGenerator FORBID_COMMENT_LIMIT = DefaultKeyGenerator.build("user", "limit", "comment");

    /**
     * 用户禁止发帖缓存
     */
    public static KeyGenerator FORBID_POST_LIMIT = DefaultKeyGenerator.build("user", "limit", "post");

    /**
     * 聊天屏蔽缓存
     */
    public static KeyGenerator IM_BLOCK_LIST = DefaultKeyGenerator.build("user", "im", "block_list");

    /**
     * 勋章刷新缓存列表
     */
    public static KeyGenerator MEDAL_REFRESH_MSG_LIST = DefaultKeyGenerator.build("user", "medal", "refresh_msg_list");

    /**
     * 邀请用户滚动弹幕
     */
    public static KeyGenerator INVITE_USER_ROLL_BARRAGE = DefaultKeyGenerator.build("user", "invite", "rollBarrage");


    /**
     * 用户绑定微信奖励
     */
    public static KeyGenerator USER_BIND_WX_REWARD = DefaultKeyGenerator.build("user", "bindwx", "reward");


    /**
     * 用户勋章数据缓存
     */
    public static KeyGenerator USER_MEDAL_NUM = DefaultKeyGenerator.build("user", "medal", "num");

    /**
     * 用户发起好友申请
     */
    public static KeyGenerator USER_FRIEND_APPLY = DefaultKeyGenerator.build("user", "friend", "apply");
}
