package com.bxm.egg.user.enums;

/**
 * @author zhaoyadong 2018/12/27 20:37
 * @desc
 */
public enum WithdrawTypeEnum {

    WX_WITHDRAW(1L, (byte) 1, "wechat", "微信"),

    ALI_WITHDRAW(2L, (byte) 2, "alipay", "支付宝");

    private Long id;

    private Byte type;

    private String name;

    private String desc;

    WithdrawTypeEnum(Long id, Byte type, String name, String desc) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    public static String getNameByChannel(Long id) {
        for (WithdrawTypeEnum withdrawTypeEnum : WithdrawTypeEnum.values()) {
            if (withdrawTypeEnum.getId().equals(id)) {
                return withdrawTypeEnum.getName();
            }
        }
        return null;
    }

    public static String getNameByType(Byte type) {
        for (WithdrawTypeEnum withdrawTypeEnum : WithdrawTypeEnum.values()) {
            if (withdrawTypeEnum.getType().equals(type)) {
                return withdrawTypeEnum.getName();
            }
        }
        return null;
    }

    public static WithdrawTypeEnum getWithdrawTypeEnum(Byte type) {
        for (WithdrawTypeEnum withdrawTypeEnum : WithdrawTypeEnum.values()) {
            if (withdrawTypeEnum.getType().equals(type)) {
                return withdrawTypeEnum;
            }
        }
        return null;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
