/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.egg.user.facade.mock;

import com.bxm.egg.common.enums.UserStatusEnum;
import com.bxm.egg.user.facade.bo.UserInfoBO;
import com.bxm.egg.user.facade.bo.UserStatisticsBO;
import com.bxm.egg.user.facade.service.UserInfoFacadeService;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class UserInfoFacadeServiceMock
implements UserInfoFacadeService {
    private static final Logger log = LoggerFactory.getLogger(UserInfoFacadeServiceMock.class);

    @Override
    public UserInfoBO selectUserFromCache(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        return this.buildInvalidUserCacheInfo(userId);
    }

    @Override
    public List<UserInfoBO> selectUserListFromCache(List<Long> userIdList) {
        log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237List\u7f13\u5b58\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", userIdList);
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_LIST;
        }
        return userIdList.stream().map(this::buildInvalidUserCacheInfo).collect(Collectors.toList());
    }

    @Override
    public Map<Long, UserInfoBO> selectUserMapFromCache(List<Long> userIdList) {
        log.error("\u6279\u91cf\u67e5\u8be2\u7528\u6237Map\u7f13\u5b58\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", userIdList);
        if (CollectionUtils.isEmpty(userIdList)) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Long, UserInfoBO> userInfoBOMap = new HashMap<Long, UserInfoBO>();
        for (Long userId : userIdList) {
            userInfoBOMap.put(userId, this.buildInvalidUserCacheInfo(userId));
        }
        return userInfoBOMap;
    }

    @Override
    public UserStatisticsBO getUserStatisticsInfo(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u7edf\u8ba1\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        UserStatisticsBO userStatisticsBO = new UserStatisticsBO();
        userStatisticsBO.setPostNum(0);
        userStatisticsBO.setReplyNum(0);
        userStatisticsBO.setAttentionNum(0);
        userStatisticsBO.setFanNum(0);
        userStatisticsBO.setLikeNum(0);
        return userStatisticsBO;
    }

    @Override
    public Long getInfoCompleteState(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u8d44\u6599\u5b8c\u6210\u5ea6\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        return 0L;
    }

    @Override
    public Boolean isNewPlatformUser(Long userId) {
        log.error("\u8c03\u7528\u662f\u5426\u662f\u5e73\u53f0\u65b0\u6ce8\u518c\u7684\u7528\u6237\u5931\u8d25\uff0c\u7528\u6237id\uff1a{}", (Object)userId);
        return false;
    }

    @Override
    public String getUserPhone(Long userId) {
        log.error("\u8c03\u7528\u67e5\u8be2\u7528\u6237\u624b\u673a\u53f7\u7801\u670d\u52a1\u5931\u8d25\uff0c\u7528\u6237id:{}", (Object)userId);
        return null;
    }

    private UserInfoBO buildInvalidUserCacheInfo(Long userId) {
        UserInfoBO userCacheInfoBO = new UserInfoBO();
        userCacheInfoBO.setHeadImg("http://bxm-news.oss-cn-hangzhou.aliyuncs.com/img/defaultHeadImg.png");
        userCacheInfoBO.setUserId(userId);
        userCacheInfoBO.setNickname("\u672a\u77e5\u7528\u6237");
        userCacheInfoBO.setState(UserStatusEnum.DISABLE.getCode());
        return userCacheInfoBO;
    }

    @Override
    public UserInfoBO getBriefUserInfo(Long userId) {
        log.error("\u67e5\u8be2\u7528\u6237\u7b80\u6613\u4fe1\u606f\u5931\u8d25, \u7528\u6237id\uff1a{}", (Object)userId);
        return this.buildInvalidUserCacheInfo(userId);
    }
}

