package com.bxm.egg.user.integration;

import com.bxm.egg.user.constant.DomainScene;
import com.bxm.egg.user.dto.AvailableDomainInfo;
import com.bxm.egg.user.dto.ViewSceneDomain;
import com.bxm.foundation.base.facade.service.DomainFacadeService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/7 8:44 下午
 */
@Service
public class DomainIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.DomainFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private DomainFacadeService domainFacadeService;

    /**
     * 根据场景获取域名
     *
     * @param scene     {@link DomainScene}
     * @param appId     appId 某些场景如微信环境的授权，是需要appId和域名相互绑定的 所以需要传入app id来获取对应的域名
     * @param viewScene 落地页场景值 如果选择的是站外分享，则需要指定具体的落地页类型 CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW:
     *                  站外推广落地页 ACTIVITY_VIEW: 站外活动落地页
     *                  {@link DomainScene.DomainViewScene}
     * @return 包含了域名、baseUrl（如果有需要则会拼接）的信息
     */
    ResponseEntity<AvailableDomainInfo> getBaseUrlInfoByScene(String scene,
                                                              String viewScene,
                                                              String appId) {
        //TODO:后面补充
        return null;
    }

    /**
     * @param viewScene CONTENT_VIEW: 站外内容落地页 PROMOTION_VIEW: 站外推广落地页 ACTIVITY_VIEW: 站外活动落地页
     * @return 落地页的域名信息
     */
    ResponseEntity<ViewSceneDomain> getViewSceneBaseUrl(String viewScene) {
        //TODO:后面补充
        return null;
    }

    /**
     * 根据场景获取域名
     *
     * @param scene     场景值
     * @param appId     appId 某些场景如微信环境的授权，是需要appId和域名相互绑定的 所以需要传入app id来获取对应的域名
     * @param viewScene 落地页场景值 如果选择的是站外分享，则需要指定具体的落地页类型 {@link DomainScene.DomainViewScene}
     * @return 包含了域名、baseUrl（如果有需要则会拼接）的信息
     */
    public Optional<AvailableDomainInfo> getBaseUrlInfoByScene(DomainScene scene, DomainScene.DomainViewScene viewScene,
                                                               String appId) {

        return Optional.empty();
    }

    /**
     * 根据请求参数，获取具体落地页的域名信息
     *
     * @param viewScene 落地页场景类型
     * @return 落地页的域名信息
     */
    public Optional<ViewSceneDomain> getViewSceneBaseUrl(DomainScene.DomainViewScene viewScene) {

        return Optional.empty();
    }

    private String getByScene(DomainScene scene) {

        return "";
    }

    /**
     * 获取内部H5 base url
     *
     * @return 内部H5 base url
     */
    public String getInnerH5BaseUrl() {
        return getByScene(DomainScene.INNER_H5);
    }

    /**
     * 获取分享的base url
     *
     * @param viewScene 分享落地页的类型
     * @return 分享的base url
     */
    public String getOutSideShareBaseUrl(DomainScene.DomainViewScene viewScene) {
        Optional<AvailableDomainInfo> baseUrlInfoByScene = getBaseUrlInfoByScene(DomainScene.OUTSIDE_SHARE, viewScene, null);
        return baseUrlInfoByScene.isPresent() ? baseUrlInfoByScene.get().getBaseUrl() : "";
    }

    /**
     * 获取服务器的base url
     *
     * @return 服务器的base url
     */
    public String getServerHostBaseUrl() {
        return getByScene(DomainScene.SERVER_HOST);
    }

}