package com.bxm.egg.user.integration;

import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/7 8:05 下午
 */
@Slf4j
@Service
@Getter
public class MessageFacadeIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.MessageIntegrationServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private MessageFacadeService messageFacadeService;

    public void sendPushMessage(PushMessage message) {
        messageFacadeService.sendPushMessage(message);
    }

    public Integer getUnReadMessageNum(Long userId, MessageTypeEnum messageType) {

        return messageFacadeService.getUnreadMsg(userId, messageType);
    }

    /**
     * 新增粉丝时，同步到消息服务，给用户个人消息中显示
     *
     * @param userId 对应的用户ID
     */
    public void addFollowMessage(Long userId) {
        PushMessage pushMessage = PushMessage.build();
        pushMessage.setPersistence(false);
        pushMessage.setTitle("新增粉丝");
        pushMessage.setContent("粉丝+1");
        pushMessage.getPayloadInfo().setType(PushMessageEnum.ADD_FUNS.getType());

        addMessage(pushMessage, userId);
    }

    private void addMessage(PushMessage pushMessage, Long userId) {
        pushMessage.assign(userId);

        messageFacadeService.sendUserMessage(pushMessage);
    }
}