package com.bxm.egg.user.integration;

import com.bxm.egg.user.dto.ForumPostBriefInfoDto;
import com.bxm.egg.user.dto.TopicFacadeVO;
import com.bxm.egg.user.vo.RecommendUserFacadeVo;
import com.bxm.localnews.news.facade.ForumFacadeService;
import com.bxm.localnews.news.facade.dto.ForumPostBriefInfoDTO;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.dto.TopicFacadeDTO;
import lombok.extern.log4j.Log4j2;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 新闻服务集成服务接口
 *
 * @author liujia
 * @date 2020/05/12 10:55
 */
@Component
@Log4j2
public class NewsIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.ForumFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private ForumFacadeService forumFacadeService;


    public ForumPostBriefInfoDto getPostWithoutDetail(Long postId) {

        ForumPostBriefInfoDTO briefInfo = forumFacadeService.getBriefInfo(postId);

        ForumPostBriefInfoDto resultInfo = new ForumPostBriefInfoDto();

        BeanUtils.copyProperties(briefInfo, resultInfo);

        return resultInfo;
    }

    public TopicFacadeVO getTopicById(Long topicId) {
        TopicFacadeDTO topic = forumFacadeService.getTopicById(topicId);
        TopicFacadeVO topicFacadeVO = new TopicFacadeVO();

        BeanUtils.copyProperties(topic, topicFacadeVO);
        return topicFacadeVO;
    }

    public Integer getPublishPostNum(Long userId) {
        //TODO:
        return 20;
    }

    public List<RecommendUserFacadeVo> getRecommendUserList(String areaCode, Long userId) {
        try {

            List<RecommendUserDTO> recommendUserInfo = forumFacadeService.getRecommendUserInfo(areaCode, userId);

            return recommendUserInfo.stream()
                    .map(this::convertToRecommendUserFacadeVo)
                    .collect(Collectors.toList());
        } catch (Exception e) {
            log.error("调用服务异常 ： {}", e.getMessage(), e);
        }
        return new ArrayList<>();
    }

    private RecommendUserFacadeVo convertToRecommendUserFacadeVo(RecommendUserDTO recommendUserDTO) {
        RecommendUserFacadeVo recommendUserFacadeVo = new RecommendUserFacadeVo();

        BeanUtils.copyProperties(recommendUserDTO, recommendUserFacadeVo);

        return recommendUserFacadeVo;
    }
}
