package com.bxm.egg.user.integration.invite;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.model.dto.invite.egg.FriendContributeInfoDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.egg.user.model.param.invite.egg.ReceiveContributeFoodsParam;
import com.bxm.newidea.component.bo.Message;
import com.bxm.newidea.component.dto.IPageModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 * 蛋蛋佳邀请
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/26 5:51 下午
 */
@Slf4j
@Service
public class UserEggInviteIntegration {

    /**
     * 分页获取用户邀请列表
     *
     * @param invitePageParam 入参
     * @return 分页邀请数据
     */
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {

        InviteUserListDTO listItem1 = new InviteUserListDTO();
        listItem1.setUserId(1L);
        listItem1.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/45a4568114ee4f8eb8cdf8e8cfcbd83c.png");
        listItem1.setNickName("虚拟用户1");
        listItem1.setHasEggNum(22);
        listItem1.setContributeEggNum(11);
        listItem1.setContributeFoodsNum(200);

        InviteUserListDTO listItem2 = new InviteUserListDTO();
        listItem2.setUserId(2L);
        listItem2.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/1ed3efa17ec54f63b358a30fd32be399.png");
        listItem2.setNickName("虚拟用户2");
        listItem2.setHasEggNum(211);
        listItem2.setContributeEggNum(13);
        listItem2.setContributeFoodsNum(200);

        InviteUserListDTO listItem3 = new InviteUserListDTO();
        listItem3.setUserId(3L);
        listItem3.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/cc05c91e2823457fbd622a57cfc4026b.png");
        listItem3.setNickName("虚拟用户3");
        listItem3.setHasEggNum(211);
        listItem3.setContributeEggNum(14);
        listItem3.setContributeFoodsNum(600);


        //TODO
        IPage<InviteUserListDTO> page = new Page<>();
        page.setTotal(3);
        page.setRecords(Arrays.asList(listItem1, listItem2, listItem3));

        return PlusPageModelDTO.build(page);
    }


    /**
     * 获取好友贡献粮食数据
     *
     * @param userId 用户id
     * @return 好友贡献粮食数据
     */
    public FriendContributeInfoDTO getFriendContributeInfo(Long userId) {
        //TODO

        FriendContributeInfoDTO friendContributeInfoDTO = new FriendContributeInfoDTO();

        friendContributeInfoDTO.setContributeFoodsNum(10);
        friendContributeInfoDTO.setWaitReceiveFoodsNum(20);

        return friendContributeInfoDTO;
    }

    /**
     * 领取好友贡献粮食
     *
     * @param receiveContributeFoodsParam 入参
     * @return 结果信息
     */
    public Message receiveContributeFoods(ReceiveContributeFoodsParam receiveContributeFoodsParam) {
        //TODO


        return Message.build(true);
    }
}