package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.service.HuolaUserDataSyncService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:41 下午
 */
@Slf4j
@Service
public class HuolaUserDataSyncIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.HuolaUserDataSyncServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private HuolaUserDataSyncService huolaUserDataSyncService;

    /**
     * 用户数据迁移
     *
     * @param userId 用户id
     */
    public void userDataSync(Long userId) {
        huolaUserDataSyncService.userDataSync(userId);
    }
}