package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.param.UserRegisterParam;
import com.bxm.sync.facade.service.HuolaUserRegisterService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:40 下午
 */
@Slf4j
@Service
public class HuolaUserRegisterIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.HuolaUserRegisterServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private HuolaUserRegisterService huolaUserRegisterService;

    /**
     * 注册用户接口【作用：返回蛋蛋佳自增id，并将信息同步到蛋蛋佳】
     *
     * @param userRegisterParam 用户注册参数
     * @return 用户id
     */
    public Long userRegister(UserRegisterParam userRegisterParam) {
        return huolaUserRegisterService.userRegister(userRegisterParam);
    }
}