package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.dto.UserAssociateDataDTO;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import com.bxm.sync.facade.service.SixEnjoyDataStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:39 下午
 */
@Slf4j
@Service
public class SixEnjoyDataStatisticsIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyDataStatisticsServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SixEnjoyDataStatisticsService sixEnjoyDataStatisticsService;

    /**
     * 获取蛋蛋佳优惠券统计信息
     *
     * @param userId 用户id
     * @return 用户优惠券统计信息
     */
    public UserCouponsStatisticsDTO getCouponsStatistics(Long userId) {
        return sixEnjoyDataStatisticsService.getCouponsStatistics(userId);
    }

    /**
     * 获取蛋蛋佳联营人信息
     *
     * @param userId    用户id
     * @param isCompany 是否是代理人
     * @return 联营人相关信息
     */
    public UserAssociateDataDTO getUserAssociateData(Long userId, Boolean isCompany) {
        return sixEnjoyDataStatisticsService.getUserAssociateData(userId, isCompany);
    }
}