package com.bxm.egg.user.vo;

import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Tolerate;

import java.io.Serializable;


@Data
@EqualsAndHashCode
@Builder
public class ImChatroom implements Serializable {

    private static final long serialVersionUID = -4650120839129524703L;

    @Tolerate
    public ImChatroom() {
    }

    private Long id;

    /**
     * 地区编码
     */
    private String areaCode;

    /**
     * 聊天室id
     */
    private String chatRoomId;

    /**
     * 聊天室名称
     */
    private String chatRoomName;

    /**
     * 是否开启定时红包(0:关闭  1:开启)
     */
    private Byte enableTimingRedPacket;

    /**
     * 是否开启聊天室(是否开启聊天室 0:关闭  1:开启)
     */
    private Byte enableChatRoom;
}