package com.bxm.egg.user.integration;

import com.bxm.egg.message.facade.service.IMFacadeService;
import com.bxm.newidea.component.bo.Message;
import com.google.common.base.Preconditions;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class IMIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.message.facade.mock.IMFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private IMFacadeService imFacadeService;


    public void syncUser(Long userId, String nickName, String headImg) {
        Preconditions.checkArgument(null != userId);

        imFacadeService.syncUserInfo(userId, nickName, headImg);
    }

    /**
     * 封禁用户即时通讯能力
     *
     * @param userId  屏蔽的用户ID
     * @param endTime 屏蔽截止时间
     * @return true表示操作成功
     */
    public Boolean block(Long userId, Date endTime) {

        Message resultMsg = imFacadeService.block(userId, endTime);

        return resultMsg.isSuccess();
    }

    public Boolean unblock(Long userId) {
        Message resultMsg = imFacadeService.unblock(userId);

        return resultMsg.isSuccess();
    }
}
