package com.bxm.egg.user.integration;

import com.bxm.egg.facade.dto.LocationDetailDTO;
import com.bxm.egg.facade.service.LocationFacadeService;
import com.bxm.egg.user.dto.LocationDTO;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

/**
 * 根据编码获取地区相关信息
 *
 * @author zhaoyadong 2019/3/1 14:00
 */
@Service
public class LocationIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.LocationFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true)
    private LocationFacadeService locationFacadeService;


    public LocationDTO getLocationByGeocode(String code) {
        LocationDTO locationDTO = new LocationDTO();

        if (StringUtils.isBlank(code)) {
            locationDTO.setCode("341822000000");
            locationDTO.setName("广德");
            locationDTO.setHot((byte) 1);
            locationDTO.setLevel((byte) 3);
            locationDTO.setLng(119.420935D);
            locationDTO.setLat(30.877555D);
            locationDTO.setFullName("安徽省宣城市广德市");

            return locationDTO;
        }

        LocationDetailDTO locationDetailDTO = locationFacadeService.getLocationDetailByCode(code);

        BeanUtils.copyProperties(locationDetailDTO, locationDTO);

        return locationDTO;
    }
}
