package com.bxm.egg.user.integration;

import com.bxm.egg.mq.common.constant.PushMessageEnum;
import com.bxm.egg.mq.common.constant.TemplateTypeEnum;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.model.dto.PushPayloadInfo;
import com.bxm.egg.mq.common.model.dto.PushReceiveScope;
import com.bxm.egg.user.model.dto.LocationUserInfoDTO;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.uuid.config.SequenceHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

import static com.bxm.newidea.component.tools.DateUtils.DATE_TIME_FORMAT_THREAD_LOCAL;
import static org.apache.commons.lang3.StringUtils.join;

/**
 * 消息推送集成服务
 *
 * @author zhaoyadong 2019/3/14 15:58
 */
@Slf4j
@Service
public class PushMsgIntegrationService {

    @Resource
    private MessageFacadeIntegrationService messageSender;

    @Resource
    private DomainIntegrationService domainIntegrationService;

    @Resource
    private SequenceCreater sequenceCreater;

    public static final String postDetail = "wst://community/postDetail?postId=%s&tp=post";

    /**
     * 推送邀请通知
     */
    public void sendSystemMessage(Long userId, int num, LocationUserInfoDTO location) {
        String url = "wst://mine/userHomePage?userId=" + userId;
        String copyWrite = "最近有" + num + "人查看了你的主页，看看都有谁。";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.addExtend("msgId", SequenceHolder.nextLongId());
        info.addExtend("url", url);
        info.setProtocol(buildProtocol(userId, location));

        PushMessage message = PushMessage.build();
        message.setTitle("通知");
        message.setContent(copyWrite);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    private String buildProtocol(Long userId, LocationUserInfoDTO location) {
        if (null == location) {
            return null;
        }

        String visitorHtml = join(domainIntegrationService.getInnerH5BaseUrl(),
                "index.html#/visitor?userId=", userId,
                "&areaCode=", location.getLocationCode(),
                "&areaName=", location.getLocationName());

        log.debug("最近访问人数跳转访问地址：[{}]", visitorHtml);

        return visitorHtml;
    }

    /**
     * 给用户推送收徒信息
     *
     * @param userId    接收消息的用户
     * @param inviteNum 用户昨日收徒数量
     */
    public void pushUserInvite(Long userId, Integer inviteNum, LocationUserInfoDTO location) {
        if (null == location) {
            return;
        }
        String protocol = domainIntegrationService.getInnerH5BaseUrl() + "/" +
                "tk/member.html#/app/apprentice/my?userId=" + userId +
                "&areaCode=" + location.getLocationCode() +
                "&areaName=" + location.getLocationName();

        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.OPEN_URL);
        info.setProtocol(protocol);

        PushMessage message = PushMessage.build();
        message.setTitle("收徒情况通知");
        message.setContent("你昨天收了" + inviteNum + "位徒弟，快去看看都是谁吧");
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }

    public void pushBlockMsg(String actions, Date endTime, Long userId, Long targetPostId) {
        // 经举报和审核，你已违反本地万事通管理规范，被禁止发帖，2021-10-12 00:00:00后可恢复正常状态
        String content = "经举报和审核，你已违反本地万事通管理规范，被" + actions + "，" + DATE_TIME_FORMAT_THREAD_LOCAL.get().format(endTime) + "后可恢复正常状态";
        PushPayloadInfo info = PushPayloadInfo.build(PushMessageEnum.JUMP_TYPE);
        Long msgId = sequenceCreater.nextLongId();
        info.setMsgId(msgId);
        // 跳转帖子详情页，帖子ID：4000000000182903（正式环境）
        info.setProtocol(String.format(postDetail, targetPostId));
        info.addExtend("msgId", msgId);
        PushMessage message = PushMessage.build();
        message.setTitle("违规处理通知");
        message.setContent(content);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle(userId));
        message.setPayloadInfo(info);

        messageSender.sendPushMessage(message);
    }
}
