package com.bxm.egg.user.integration;

import com.bxm.egg.user.dto.UserImgDTO;
import com.bxm.egg.user.facade.UserNewsFeignService;
import com.bxm.egg.user.model.dto.ImgDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 对facade接口进行二次封装，用于适配和兼容
 *
 * @author liujia
 */
@Service
public class UserNewsIntegrationService {

    @Autowired
    private UserNewsFeignService userNewsFeignService;

    public Map<Long, List<ImgDTO>> batchGetUserImg(List<Long> userIdList) {
        Map<Long, List<ImgDTO>> imgMap = new HashMap<>();
        ResponseEntity<List<UserImgDTO>> userImgListEntity = userNewsFeignService.batchGetUserImg(userIdList, null);
        List<UserImgDTO> userImgDTOList = userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty(userImgDTOList)) {
            userImgDTOList.forEach(e -> {
                //大于4张的显示4张，小于4张的不显示
                if (e.getImgDtoList().size() >= 4) {
                    imgMap.put(e.getUserId(), subImgList(e.getImgDtoList(), 4));
                }
            });
        }
        return imgMap;
    }

    public Map<Long, List<ImgDTO>> batchGetAllUserImg(List<Long> userIdList, Long userId) {
        Map<Long, List<ImgDTO>> imgMap = new HashMap<>();
        //TODO:对接news用户
//        ResponseEntity<List<UserImgDTO>> userImgListEntity = userNewsFeignService.batchGetUserImg(userIdList, userId);
//        List<UserImgDTO> userImgDTOList = userImgListEntity.getBody();
//        if (!CollectionUtils.isEmpty(userImgDTOList)) {
//            userImgDTOList.forEach(e -> {
//                imgMap.put(e.getUserId(), subImgList(e.getImgDtoList(), 4));
//
//            });
//        }
        ImgDTO imgDTO1 = new ImgDTO();
        imgDTO1.setId(1L);
        imgDTO1.setImgUrl("https://m.wstong.com/localnews_prod/avatar/31/100000631.jpeg");
        imgDTO1.setCategory("吐槽");
        imgDTO1.setType("1");

        ImgDTO imgDTO2 = new ImgDTO();
        imgDTO2.setId(1L);
        imgDTO2.setImgUrl("https://m.wstong.com/localnews_prod/avatar/31/100000631.jpeg");
        imgDTO2.setCategory("吐槽");
        imgDTO2.setType("1");

        ImgDTO imgDTO3 = new ImgDTO();
        imgDTO3.setId(1L);
        imgDTO3.setImgUrl("https://m.wstong.com/localnews_prod/avatar/31/100000631.jpeg");
        imgDTO3.setCategory("吐槽");
        imgDTO3.setType("1");
        List<ImgDTO> imgDTOList = Arrays.asList(imgDTO1, imgDTO2, imgDTO3);

        imgMap.put(14682755894216490L, imgDTOList);
        imgMap.put(14696511856575354L, imgDTOList);
        imgMap.put(14682727006472014L, imgDTOList);
        return imgMap;
    }

    private List<ImgDTO> subImgList(List<ImgDTO> imgDTOList, int limit) {
        if (imgDTOList.size() >= limit) {
            return imgDTOList.subList(0, limit);
        } else {
            return imgDTOList;
        }
    }
}
