package com.bxm.egg.user.integration;

import com.bxm.localnews.news.facade.UserSyncFacadeService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:10 下午
 */
@Service
public class UserSyncIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.UserSyncFacadeServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private UserSyncFacadeService userSyncFacadeService;

    /**
     * 切换定位
     *
     * @param userId   用户id
     * @param areaCode 地区编码
     */
    public void changeLocation(Long userId, String areaCode) {
        userSyncFacadeService.changeLocation(userId, areaCode);
    }

    /**
     * 添加关注
     *
     * @param userId       用户id
     * @param followUserId 关注用户id
     */
    public void addFollow(Long userId, Long followUserId) {
        userSyncFacadeService.addFollow(userId, followUserId);
    }

    /**
     * 移除关注
     *
     * @param userId         用户id
     * @param unfollowUserId 移除关注用户
     */
    public void removeFollow(Long userId, Long unfollowUserId) {
        userSyncFacadeService.removeFollow(userId, unfollowUserId);
    }
}