package com.bxm.egg.user.integration.fallback;

import com.bxm.localnews.news.facade.ForumFacadeService;
import com.bxm.localnews.news.facade.dto.ForumPostBriefInfoDTO;
import com.bxm.localnews.news.facade.dto.RecommendUserDTO;
import com.bxm.localnews.news.facade.dto.TopicFacadeDTO;
import com.bxm.localnews.news.facade.dto.UserImgDTO;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/30 2:04 下午
 */
@Slf4j
public class ForumFacadeServiceMock implements ForumFacadeService {
    @Override
    public List<UserImgDTO> batchGetUserImg(List<Long> userIdList, Long currentUserId) {
        log.error("批量获取用户图片服务调用失败，用户id列表:{}, 当前用户id:{}", userIdList, currentUserId);
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<RecommendUserDTO> getRecommendUserInfo(String areaCode, Long userId) {
        log.error("获取推荐用户列表服务调用失败，areaCode：{}, 用户id:{}", areaCode, userId);
        return Collections.EMPTY_LIST;
    }

    @Override
    public TopicFacadeDTO getTopicById(Long topicId) {
        log.error("获取话题信息失败，话题id:{}", topicId);
        return null;
    }

    @Override
    public ForumPostBriefInfoDTO getBriefInfo(Long postId) {
        log.error("获取帖子信息失败，帖子id:{}", postId);
        return null;
    }
}