package com.bxm.egg.user.integration.fallback;

import com.alibaba.fastjson.JSON;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.constant.MessageTypeEnum;
import com.bxm.egg.mq.common.model.dto.MessageFilterInfo;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.mq.common.param.DingtalkMessage;
import lombok.extern.slf4j.Slf4j;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/7 8:06 下午
 */
@Slf4j
public class MessageIntegrationServiceMock implements MessageFacadeService {
    @Override
    public void sendPushMessage(PushMessage message) {
        log.error("推送失败，原始参数信息：{}", JSON.toJSONString(message));
    }

    @Override
    public void sendUserMessage(PushMessage message) {
        log.error("推送失败，原始参数信息：{}", JSON.toJSONString(message));
    }

    @Override
    public void sendMsgFilterEvent(MessageFilterInfo info) {
        log.error("推送失败，原始参数信息：{}", JSON.toJSONString(info));
    }

    @Override
    public void sendDingtalk(DingtalkMessage message) {
        log.error("推送失败，原始参数信息：{}", JSON.toJSONString(message));
    }

    @Override
    public Integer getUnreadMsg(Long aLong, MessageTypeEnum messageTypeEnum) {
        return null;
    }
}