package com.bxm.egg.user.integration.fallback.sync;

import com.alibaba.fastjson.JSON;
import com.bxm.sync.facade.param.DelUserParam;
import com.bxm.sync.facade.param.UserRegisterParam;
import com.bxm.sync.facade.service.HuolaUserRegisterService;
import lombok.extern.slf4j.Slf4j;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:54 下午
 */
@Slf4j
public class HuolaUserRegisterServiceMock implements HuolaUserRegisterService {
    @Override
    public Long userRegister(UserRegisterParam userRegisterParam) {
        log.error("注册用户失败, 入参: {}", JSON.toJSONString(userRegisterParam));
        return -1L;
    }

    @Override
    public Boolean delUser(DelUserParam delUserParam) {
        log.error("注销用户失败, 入参: {}", JSON.toJSONString(delUserParam));
        return false;
    }
}