package com.bxm.egg.user.integration.fallback.sync;

import com.alibaba.fastjson.JSON;
import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import com.bxm.sync.facade.service.SixEnjoyInviteFoodsService;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/9 6:32 下午
 */
@Slf4j
public class SixEnjoyInviteFoodsServiceMock implements SixEnjoyInviteFoodsService {
    @Override
    public Integer getReceiveFoods(Long userId) {
        log.error("调用用户邀请获得粮食服务失败，用户id:{}", userId);
        return 0;
    }

    @Override
    public List<InviteFoodsDTO> getTodayContribution(InviteFoodsParam inviteFoodsParam) {
        log.error("调用用户邀请列表服务失败，入参:{}", JSON.toJSONString(inviteFoodsParam));
        return Collections.EMPTY_LIST;
    }
}