package com.bxm.egg.user.integration.invite;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.component.mybatis.dto.PlusPageModelDTO;
import com.bxm.egg.user.model.dto.invite.egg.InviteUserListDTO;
import com.bxm.egg.user.model.param.invite.egg.InvitePageParam;
import com.bxm.newidea.component.dto.IPageModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Arrays;

/**
 * 蛋蛋佳邀请
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/26 5:51 下午
 */
@Slf4j
@Service
public class UserEggInviteIntegration {

    /**
     * 分页获取用户邀请列表
     *
     * @param invitePageParam 入参
     * @return 分页邀请数据
     */
    public IPageModel<InviteUserListDTO> inviteList(InvitePageParam invitePageParam) {

        InviteUserListDTO listItem1 = new InviteUserListDTO();
        listItem1.setUserId(1L);
        listItem1.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/45a4568114ee4f8eb8cdf8e8cfcbd83c.png");
        listItem1.setNickName("虚拟用户1");
        listItem1.setHasEggNum(22);
        listItem1.setTodayContributeFoodsNum(11);

        InviteUserListDTO listItem2 = new InviteUserListDTO();
        listItem2.setUserId(2L);
        listItem2.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/1ed3efa17ec54f63b358a30fd32be399.png");
        listItem2.setNickName("虚拟用户2");
        listItem2.setHasEggNum(211);
        listItem2.setTodayContributeFoodsNum(56);

        InviteUserListDTO listItem3 = new InviteUserListDTO();
        listItem3.setUserId(3L);
        listItem3.setHeadImg("https://bxm-ypj01.oss-cn-hangzhou.aliyuncs.com/cc05c91e2823457fbd622a57cfc4026b.png");
        listItem3.setNickName("虚拟用户3");
        listItem3.setHasEggNum(211);
        listItem3.setTodayContributeFoodsNum(31);


        //TODO
        IPage<InviteUserListDTO> page = new Page<>();
        page.setTotal(3);
        page.setRecords(Arrays.asList(listItem1, listItem2, listItem3));

        return PlusPageModelDTO.build(page);
    }
}