package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.service.SixEnjoyFriendsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:42 下午
 */
@Slf4j
@Service
public class SixEnjoyFriendsIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyFriendsServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SixEnjoyFriendsService sixEnjoyFriendsService;

    /**
     * 同步好友关系到六享
     *
     * @param userId       用户id
     * @param friendUserId 好友用户id
     */
    public void insertFriendsToSixEnjoy(Long userId, Long friendUserId) {
        sixEnjoyFriendsService.insertFriendsToSixEnjoy(userId, friendUserId);
    }

    /**
     * 从六享删除好友关系
     *
     * @param userId       用户id
     * @param friendUserId 好友用户id
     */
    public void delFriendsToSixEnjoy(Long userId, Long friendUserId) {
        sixEnjoyFriendsService.delFriendsToSixEnjoy(userId, friendUserId);
    }
}