package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import com.bxm.sync.facade.service.SixEnjoyInviteFoodsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/9 6:29 下午
 */
@Slf4j
@Service
public class SixEnjoyInviteFoodsIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyInviteFoodsServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SixEnjoyInviteFoodsService sixEnjoyInviteFoodsService;

    public Integer getReceiveFoods(Long userId) {
        return sixEnjoyInviteFoodsService.getReceiveFoods(userId);
    }

    public List<InviteFoodsDTO> getTodayContribution(InviteFoodsParam inviteFoodsParam) {
        return sixEnjoyInviteFoodsService.getTodayContribution(inviteFoodsParam);
    }
}