package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.service.SixEnjoyUserAccountService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:36 下午
 */
@Slf4j
@Service
public class SixEnjoyUserAccountIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyUserAccountServiceMock",
            cluster = "failfast",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SixEnjoyUserAccountService sixEnjoyUserAccountService;

    /**
     * 增加用户粮食数量
     *
     * @param userId   用户id
     * @param foodsNum 增加粮食数量
     * @return 是否成功
     */
    public Boolean addFoodsNum(Long userId, Integer foodsNum, String remark) {
        return sixEnjoyUserAccountService.addFoodsNum(userId, foodsNum, remark);
    }

    /**
     * 减少用户粮食数量
     *
     * @param userId   用户id
     * @param foodsNum 减少粮食数量
     * @return 是否成功
     */
    public Boolean subFoodsNum(Long userId, Integer foodsNum, String remark) {
        return sixEnjoyUserAccountService.subFoodsNum(userId, foodsNum, remark);
    }

    /**
     * 增加鸡蛋的数量
     *
     * @param userId  用户id
     * @param eggsNum 鸡蛋数量
     * @return 是否成功
     */
    public Boolean addEggsNum(Long userId, Integer eggsNum, String remark) {
        return sixEnjoyUserAccountService.addEggsNum(userId, eggsNum, remark);
    }

    /**
     * 减少鸡蛋数量
     *
     * @param userId  用户id
     * @param eggsNum 鸡蛋数量
     * @return 是否成功
     */
    public Boolean subEggsNum(Long userId, Integer eggsNum, String remark) {
        return sixEnjoyUserAccountService.subEggsNum(userId, eggsNum, remark);
    }
}