package com.bxm.egg.user.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel(description = "定位返回包装类")
@Data
public class LocationDTO {

    @ApiModelProperty("地区编码")
    private String code;

    @ApiModelProperty("地区简称")
    private String name;

    @ApiModelProperty("是否热门城市（1表示true）")
    private Byte hot;

    @ApiModelProperty("城市级别（2：市、3：县（区））")
    private Byte level;

    @ApiModelProperty("经度")
    private Double lng;

    @ApiModelProperty("纬度")
    private Double lat;

    @ApiModelProperty(value = "用户帖子发布数")
    private Integer publishPostNum;

    @ApiModelProperty("地区全称")
    private String fullName;
}
