package com.bxm.egg.user.integration;

import com.bxm.component.httpclient.utils.OkHttpUtils;
import com.bxm.egg.common.url.ProtocolFactory;
import com.bxm.egg.message.facade.service.MessageFacadeService;
import com.bxm.egg.mq.common.model.dto.PushMessage;
import com.bxm.egg.user.dto.EggResponseModel;
import com.bxm.egg.user.dto.EggSixBindResponse;
import com.bxm.egg.user.param.EggSixEnjoyBindParam;
import com.bxm.egg.user.properties.SixEnjoyUrlProperties;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.tools.StringUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static com.bxm.newidea.component.JSON.parseObject;
import static com.bxm.newidea.component.JSON.toJSONString;

/**
 * 调用六享的接口,进行微信绑定
 * 绑定成功后发送推送
 *
 * @author liujia
 * @date 10/21/21 4:56 PM
 **/
@Service
@AllArgsConstructor
@Slf4j
public class EggSixEnjoyIntegrationService {

    private SixEnjoyUrlProperties sixEnjoyUrlProperties;

    private MessageFacadeIntegrationService messageFacadeIntegrationService;

    private UserProperties userProperties;

    private final static TypeReference<EggResponseModel<EggSixBindResponse>> EGG_TYPE_REFERENCE
            = new TypeReference<EggResponseModel<EggSixBindResponse>>() {
    };

    private static final Integer SUCCESS_CODE = 1;

    @Async
    public void bind(EggSixEnjoyBindParam param) {
        if (StringUtils.isBlank(param.getAvatarUrl())) {
            param.setAvatarUrl(userProperties.getDefaultHeadImageUrl());
        }

        EggResponseModel<EggSixBindResponse> responseModel = request(param);

        if (Objects.equals(SUCCESS_CODE, responseModel.getCode())) {
            // 给邀请人发放奖励
            EggSixBindResponse data = responseModel.getData();
            if (StringUtils.isNotBlank(data.getFuser_id())) {
                Long inviteUserId = Long.valueOf(data.getFuser_id());

                PushMessage message = PushMessage.build("邀请好友绑定微信成功",
                        "您邀请的好友[" + param.getNickName() + "]，成功绑定微信，奖励"
                                + sixEnjoyUrlProperties.getAwardNum() + "g粮食");
                message.assign(inviteUserId);
                message.getPayloadInfo().setProtocol(ProtocolFactory.appH5()
                        .url(sixEnjoyUrlProperties.getInvitePage())
                        .build());

                messageFacadeIntegrationService.sendPushMessage(message);
            }
        } else {
            log.error("调用蛋蛋佳接口绑定微信失败,请求数据：{},响应结果：{}",
                    toJSONString(param),
                    toJSONString(responseModel));
        }
    }


    private EggResponseModel<EggSixBindResponse> request(EggSixEnjoyBindParam param) {
        String response = OkHttpUtils.postJsonBody(sixEnjoyUrlProperties.getWxBindAwardUrl(), toJSONString(param), null);

        if (log.isDebugEnabled()) {
            log.debug("调用蛋蛋佳,请求数据：{},响应结果：{}",
                    toJSONString(param),
                    response);
        }
        return parseObject(response, EGG_TYPE_REFERENCE);
    }
}
