package com.bxm.egg.user.integration.fallback;

import com.bxm.egg.facade.dto.LocationDetailDTO;
import com.bxm.egg.facade.service.LocationFacadeService;
import lombok.extern.slf4j.Slf4j;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/27 7:19 下午
 */
@Slf4j
public class LocationFacadeServiceMock implements LocationFacadeService {
    @Override
    public LocationDetailDTO getLocationDetailByCode(String code) {
        log.error("调用获取定位mock服务，areaCode:{}", code);

        LocationDetailDTO locationDTO = new LocationDetailDTO();

        locationDTO.setCode("341822000000");
        locationDTO.setName("广德");
        locationDTO.setHot((byte) 1);
        locationDTO.setLevel((byte) 3);
        locationDTO.setLng(119.420935D);
        locationDTO.setLat(30.877555D);
        locationDTO.setFullName("安徽省宣城市广德市");

        return locationDTO;
    }
}