package com.bxm.egg.user.integration.fallback.sync;

import com.alibaba.fastjson.JSON;
import com.bxm.sync.facade.dto.InviteFoodsDTO;
import com.bxm.sync.facade.dto.UserTodayContributionDTO;
import com.bxm.sync.facade.param.InviteFoodsParam;
import com.bxm.sync.facade.service.SixEnjoyInviteFoodsFacadeService;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/9 6:32 下午
 */
@Slf4j
public class SixEnjoyInviteFoodsServiceMock implements SixEnjoyInviteFoodsFacadeService {

    @Override
    public Integer getReceiveFoods(Long userId) {
        log.error("调用用户邀请获得粮食服务失败，用户id:{}", userId);
        return 0;
    }

    @Override
    public List<InviteFoodsDTO> getTodayContribution(InviteFoodsParam inviteFoodsParam) {
        log.error("调用用户邀请列表服务失败，入参:{}", JSON.toJSONString(inviteFoodsParam));
        return Lists.newArrayList();
    }

    @Override
    public List<UserTodayContributionDTO> getTodayContribution(List<Long> userIdList) {
        return Lists.newArrayList();
    }

    @Override
    public List<UserTodayContributionDTO> getTodayContribution(Long userId) {
        return Lists.newArrayList();
    }
}