package com.bxm.egg.user.integration;

import com.bxm.foundation.base.facade.service.SensitiveWordFacadeService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * Base基础服务集成service
 *
 * @author wzy
 * @version 1.0
 * @date 2021/9/28 11:25 上午
 */
@Service
public class SensitiveIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.SensitiveWordFacadeServiceMock",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SensitiveWordFacadeService sensitiveWordFacadeService;

    /**
     * 验证敏感词
     *
     * @param text 文本内容
     * @return 是否通过
     */
    public Boolean verifySensitiveWord(String text) {
        return sensitiveWordFacadeService.contains(text);
    }

}