package com.bxm.egg.user.integration;

import com.bxm.egg.message.facade.param.CheckSmsCodeParam;
import com.bxm.egg.message.facade.param.SmsTemplateSendParam;
import com.bxm.egg.message.facade.service.SmsFacadeService;
import com.bxm.egg.mq.common.constant.SmsTemplateEnum;
import com.bxm.egg.user.properties.UserProperties;
import com.bxm.newidea.component.bo.Message;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/7 8:31 下午
 */
@Service
public class SmsIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.SmsFacadeServiceMock",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    private SmsFacadeService smsFacadeService;

    @Resource
    private UserProperties userProperties;

    /**
     * 判断验证码是否正确
     *
     * @param type    验证码类型
     * @param phoneNo 手机号码
     * @param code    用户输入的验证码
     * @return true 表示验证通过
     */
    public Boolean verifyByType(SmsTemplateEnum type, String phoneNo, String code) {

        CheckSmsCodeParam checkSmsCodeParam = new CheckSmsCodeParam();

        checkSmsCodeParam.setCode(code);
        checkSmsCodeParam.setPhoneNum(phoneNo);
        checkSmsCodeParam.setType(type);

        return smsFacadeService.verify(checkSmsCodeParam);
    }

    /**
     * 自定义短信参数发送短信
     *
     * @param param 短信发送参数
     * @return 短信发送结果
     */
    public Message sendSMS(SmsTemplateSendParam param) {
        return smsFacadeService.send(param);
    }
}