package com.bxm.egg.user.integration.farm;

import com.bxm.farm.facade.server.ChickenGroupFacadeService;
import lombok.Getter;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Component;

/**
 * @author lowi
 * @date 2021/12/11 10:51
 */
@Component
@Getter
public class ChickenGroupIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.farm.mock.ChickenGroupFacadeServiceMock",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true)
    ChickenGroupFacadeService chickenGroupFacadeService;


    public Boolean inviteJoinGroup(Long userId, Long inviteUserId) {
        return chickenGroupFacadeService.inviteJoinGroup(userId, inviteUserId);
    }
}
