package com.bxm.egg.user.integration.sync;

import com.bxm.sync.facade.dto.UserAssociateDataDTO;
import com.bxm.sync.facade.dto.UserCouponsStatisticsDTO;
import com.bxm.sync.facade.dto.UserUseEggNumDTO;
import com.bxm.sync.facade.service.SixEnjoyDataStatisticsService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/10/7 4:39 下午
 */
@Slf4j
@Service
public class SixEnjoyDataStatisticsIntegrationService {
    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.sync.SixEnjoyDataStatisticsServiceMock",
            cluster = "failover",
            version = "1.0.0",
            timeout = 10000,
            check = false,
            lazy = true
    )
    private SixEnjoyDataStatisticsService sixEnjoyDataStatisticsService;

    /**
     * 获取蛋蛋佳优惠券统计信息
     *
     * @param userId 用户id
     * @return 用户优惠券统计信息
     */
    public UserCouponsStatisticsDTO getCouponsStatistics(Long userId) {
        UserCouponsStatisticsDTO couponsStatistics = sixEnjoyDataStatisticsService.getCouponsStatistics(userId);
        if (couponsStatistics == null) {
            return UserCouponsStatisticsDTO.builder()
                    .eggCoupon(0)
                    .cardCoupon(0)
                    .build();
        }

        return couponsStatistics;
    }

    /**
     * 获取蛋蛋佳联营人信息
     *
     * @param userId    用户id
     * @param isCompany 是否是代理人
     * @return 联营人相关信息
     */
    public UserAssociateDataDTO getUserAssociateData(Long userId, Boolean isCompany) {
        UserAssociateDataDTO userAssociateData = sixEnjoyDataStatisticsService.getUserAssociateData(userId, isCompany);

        if (userAssociateData == null) {
            return buildDefaultInvalidAssociateData();
        }

        return userAssociateData;
    }

    private UserAssociateDataDTO buildDefaultInvalidAssociateData() {
        return UserAssociateDataDTO.builder()
                .orderNumByWeek(0)
                .orderNumByMonth(0)
                .orderNumByDay(0)
                .equipmentNum(0)
                .associateNum(0)
                .build();
    }

    public List<UserUseEggNumDTO> getUserUseEggNumMaxList() {
        return sixEnjoyDataStatisticsService.getUserUseEggNumMaxList();
    }
}