package com.bxm.egg.user.integration;

import com.bxm.sync.facade.dto.UserRewardDTO;
import com.bxm.sync.facade.param.UpdateUserRewardParam;
import com.bxm.sync.facade.service.SixEnjoyUserFacadeService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/11/10 9:38
 */
@Service
public class SixEnjoyUserIntegrationService {

    @DubboReference(protocol = "dubbo",
            mock = "com.bxm.egg.user.integration.fallback.SixEnjoyUserIntegrationServiceMock",
            cluster = "failover",
            version = "1.0.0",
            check = false,
            lazy = true
    )
    SixEnjoyUserFacadeService sixEnjoyUserFacadeService;

    public UserRewardDTO getUserRewardInfo(Long userId, String phone, Long devcId) {
        return sixEnjoyUserFacadeService.getUserRewardInfo(userId, phone, devcId);
    }

    public Boolean updateUserReward(UpdateUserRewardParam updateUserRewardParam) {
        return sixEnjoyUserFacadeService.updateUserReward(updateUserRewardParam);
    }

    public Boolean updateUserInvite(Long userId, Long inviteUserId) {
        return sixEnjoyUserFacadeService.updateUserInvite(userId, inviteUserId);
    }


}
