package com.bxm.egg.user.integration.fallback;

import com.bxm.foundation.base.facade.service.SensitiveWordFacadeService;
import lombok.extern.slf4j.Slf4j;

import java.util.Collections;
import java.util.List;

/**
 * @author wzy
 * @version 1.0
 * @date 2021/9/30 2:18 下午
 */
@Slf4j
public class SensitiveWordFacadeServiceMock implements SensitiveWordFacadeService {
    @Override
    public boolean contains(String source) {
        log.error("调用是否包含敏感词失败，文本内容: {}", source);
        return false;
    }

    @Override
    public List<String> match(String source, boolean skipStopWord, boolean searchAll) {
        log.error("调用匹配敏感词服务失败，文本信息:{}, 是否跳过停顿处：{}, 是否搜索多有内容：{}",
                source, skipStopWord, searchAll);
        return Collections.EMPTY_LIST;
    }
}